/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.util.ArrayList;
import java.util.Iterator;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedBox2DException;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.domain.Contour2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.polygon.Polyline2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Boundary2DUtils {
    public static final CurveSet2D<ContinuousOrientedCurve2D> clipContinuousOrientedCurve(ContinuousOrientedCurve2D curve, Box2D box) {
        CurveArray2D<ContinuousOrientedCurve2D> result = new CurveArray2D<ContinuousOrientedCurve2D>();
        for (ContinuousCurve2D cont : Curve2DUtils.clipContinuousCurve(curve, box)) {
            if (!(cont instanceof ContinuousOrientedCurve2D)) continue;
            result.addCurve((ContinuousOrientedCurve2D)cont);
        }
        return result;
    }

    public static final ContourArray2D<Contour2D> clipBoundary(Boundary2D boundary, Box2D box) {
        Point2D vertex;
        ContinuousOrientedCurve2D curve;
        if (!box.isBounded()) {
            throw new UnboundedBox2DException(box);
        }
        ContourArray2D<Contour2D> res = new ContourArray2D<Contour2D>();
        CurveArray2D<ContinuousOrientedCurve2D> curveSet = new CurveArray2D<ContinuousOrientedCurve2D>();
        for (Contour2D contour2D : boundary.getContinuousCurves()) {
            CurveSet2D<ContinuousOrientedCurve2D> clipped = Boundary2DUtils.clipContinuousOrientedCurve(contour2D, box);
            for (ContinuousOrientedCurve2D clip : clipped) {
                curveSet.addCurve(clip);
            }
        }
        int n = curveSet.getCurveNumber();
        double[] startPositions = new double[n];
        double[] endPositions = new double[n];
        boolean intersect = false;
        ContinuousOrientedCurve2D[] curves = new ContinuousOrientedCurve2D[n];
        Boundary2D boxBoundary = box.getBoundary();
        Iterator iter = curveSet.getCurves().iterator();
        int i = 0;
        while (i < n) {
            curves[i] = curve = (ContinuousOrientedCurve2D)iter.next();
            if (curve.isClosed()) {
                startPositions[i] = Double.NaN;
                endPositions[i] = Double.NaN;
            } else {
                startPositions[i] = boxBoundary.getPosition(curve.getFirstPoint());
                endPositions[i] = boxBoundary.getPosition(curve.getLastPoint());
                intersect = true;
            }
            ++i;
        }
        int nb = n;
        int c = 0;
        while (c < nb) {
            int ind = c;
            while (curves[ind] == null) {
                ++ind;
            }
            curve = curves[ind];
            if (curve.isClosed()) {
                if (curve instanceof Contour2D) {
                    res.addCurve((Contour2D)curve);
                } else {
                    BoundaryPolyCurve2D<ContinuousOrientedCurve2D> bnd = new BoundaryPolyCurve2D<ContinuousOrientedCurve2D>();
                    bnd.addCurve(curve);
                    res.addCurve(bnd);
                }
                curves[ind] = null;
                ++c;
                continue;
            }
            BoundaryPolyCurve2D<ContinuousOrientedCurve2D> boundary0 = new BoundaryPolyCurve2D<ContinuousOrientedCurve2D>();
            boundary0.addCurve(curve);
            Point2D p0 = curve.getFirstPoint();
            Point2D p1 = curve.getLastPoint();
            int ind0 = ind;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            indices.add(new Integer(ind));
            ind = Boundary2DUtils.findNextCurveIndex(startPositions, endPositions[ind0]);
            while (ind != ind0) {
                curve = curves[ind];
                boundary0.addCurve(Boundary2DUtils.getBoundaryPortion(box, p1, curve.getFirstPoint()));
                boundary0.addCurve(curve);
                indices.add(new Integer(ind));
                ind = Boundary2DUtils.findNextCurveIndex(startPositions, endPositions[ind]);
                p1 = curve.getLastPoint();
                --nb;
            }
            boundary0.addCurve(Boundary2DUtils.getBoundaryPortion(box, p1, p0));
            res.addCurve(boundary0);
            Iterator iter2 = indices.iterator();
            while (iter2.hasNext()) {
                curves[((Integer)iter2.next()).intValue()] = null;
            }
            ++c;
        }
        if (!intersect && boundary.isInside(vertex = box.getVertices().iterator().next())) {
            res.addCurve((Contour2D)((CurveArray2D)((Object)box.getAsRectangle().getBoundary())).getFirstCurve());
        }
        return res;
    }

    public static final int findNextCurveIndex(double[] positions, double pos) {
        int ind = -1;
        double posMin = Double.MAX_VALUE;
        int i = 0;
        while (i < positions.length) {
            if (!Double.isNaN(positions[i]) && !(positions[i] - pos < 1.0E-12) && positions[i] < posMin) {
                ind = i;
                posMin = positions[i];
            }
            ++i;
        }
        if (ind != -1) {
            return ind;
        }
        i = 0;
        while (i < positions.length) {
            if (!Double.isNaN(positions[i]) && positions[i] - posMin < 1.0E-12) {
                ind = i;
                posMin = positions[i];
            }
            ++i;
        }
        return ind;
    }

    public static final Polyline2D getBoundaryPortion(Box2D box, Point2D p0, Point2D p1) {
        int ind1;
        Boundary2D boundary = box.getBoundary();
        double t0 = boundary.getPosition(p0);
        double t1 = boundary.getPosition(p1);
        int ind0 = (int)Math.floor(t0);
        if (ind0 == (ind1 = (int)Math.floor(t1)) && t0 < t1) {
            return new Polyline2D(p0, p1);
        }
        ArrayList<Point2D> vertices = new ArrayList<Point2D>(6);
        vertices.add(p0);
        int ind = (ind0 + 1) % 4;
        while (ind != ind1) {
            vertices.add(boundary.getPoint(ind));
            ind = (ind + 1) % 4;
        }
        vertices.add(boundary.getPoint(ind));
        vertices.add(p1);
        return new Polyline2D(vertices);
    }
}

